ace.define("ace/mode/pxplus_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var PxPlusHighlightRules = function() {

    /* Rules to exclude keywords when used as variable/property names or function/method names */
    var notVarOrFuncLookBehind = "(?<!(?:\\bfunction\\b.+|,|\\(|\\=\\*?|\\+|-|\\*|\\\/|\\^|\\>|\\<|\\band|\\bor|\\[|\\bnext|\\breturn|\\bpreinput)\\s*|'|\\.)"
    var notVarOrFuncLookAhead = "(?!:|\\$|\\s*(?:,|\\)|\\=|\\+|-|\\\/|\\^|\\>|\\<|and\\b|or\\b))"

    var keywordControls = (
        "accept|add|and|auto|begin|break|call|case|catch|class|clear|close|continue|control|create|ctl|data|def|default|"+
        "defctl|delete|dictionary|dim|directory|disable|drop|edit|else|enable|end|end_if|end_try|err|error_handler|escape|event|except|"+
        "exit|exitto|file|finally|find|for|from|get|gosub|goto|hide|if|index|indexed|input|key|list|load|lock|merge|"+
        "next|object|off|on|open|perform|pop|preinput|print|process|program|properties|purge|quit|read|record|"+
        "release|remove|repeat|required|reset|restore|retry|return|run|same|save|select|server|set|set_focus|show|start|static|"+
        "step|stop|swap|switch|table|then|time|to|try|unique|unlock|until|wait|wend|where|while|window|with|write"
    );
    
    var keywordDirectives = (
        "accept|add|addr|auto|begin|button|bye|chart|check_box|clear|clip_board|close|create|custom_vbx|cwdir|data|"+
        "day_format|def|defctl|defprt|deftty|delete|dictionary|direct|directory|disable|drop|drop_box|dump|enable|endtrace|"+
        "enter|erase|error_handler|execute|extract|file|find|floatingpoint|flush|function|get_file_box|grid|h_scrollbar|"+
        "hide|indexed|insert|invoke|iolist|keyed|let|like|line_switch|list|list_box|load|local|lock|long_form|menu_bar|merge|"+
        "message_lib|mnemonic|msgbox|multi_line|multi_media|obtain|on|open|password|perform|pop|popup_menu|precision|"+
        "prefix|preinput|print|process|program|property|purge|radio_button|randomize|read|redim|refile|release|remove|rename|"+
        "renumber|reset|restore|round|save|serial|set_focus|set_param|setctl|setday|setdrive|seterr|setesc|setfid|setmouse|"+
        "settime|settrace|short_form|show|sort|static|system_help|system_jrnl|table|translate|tristate_box|unlock|update|"+
        "user_lex|v_scrollbar|vardrop_box|varlist_box|via|video_palette|wait|winprt_setup|with|write"
    );

    var keywordFunctions = (
        "@|@x|@y|abs|acs|and|arg|asc|asn|ath|atn|bin|bsz|chg|chr|cmp|cos|cpl|crc|cse|ctl|cvs|dec|deg|dim|dir|dll|dlx|"+
        "dsk|dte|env|ept|err|evn|evs|exp|ffn|fib|fid|fin|fpt|gap|gbl|gep|hsa|hsh|hta|hwn|i3e|i86|ind|int|iol|ior|jst|jul|kec|"+
        "kef|kel|ken|kep|key|kgn|lcs|len|lno|log|lrc|lst|max|mem|mid|min|mnm|mod|msg|msk|mxc|mxl|new|not|nul|num|obj|opt|pad|"+
        "pck|pfx|pgm|pos|prc|prm|pth|pub|rad|rcd|rdx|rec|ref|rnd|rno|sep|sgn|sin|sqr|srt|ssz|stk|stp|str|sub|swp|sys|tan|tbl|"+
        "tcb|tmr|trx|try|tsk|txh|txw|ucp|ucs|upk|vin|vis|xeq|xfa|xml|xor"
    );

    var keywordVariables = (
       "bkg|chn|ctl|day|dlm|dsz|eom|err|ers|esc|gfn|gid|hfn|hlp|hwd|lfa|lfo|lip|lpg|lwd|mse|msl|nar|nid|obj|pfx|pgn|prc|prm|"+
       "psz|quo|ret|rnd|sep|sid|ssn|sys|tim|tme|tms|tsm|uid|unt|who"
    );

    var keywordOperators = (
        "and|or"
    );

    this.$keywords = this.createKeywordMapper({
        "control" : keywordControls,
        "directive" : keywordDirectives,
        "functions" : keywordFunctions,
        "variables" : keywordVariables,
        "operator" : keywordOperators
    }, "identifier");

    this.$rules = {
    "start": [
        {
            token: [
                "meta.ending-space"
            ],
            regex: "$"
        },
        {
            token: [
                null
            ],
            regex: "^(?=\\t)",
            next: "state_3"
        },
        {
            token: [null],
            regex: "^(?= )",
            next: "state_4"
        },
        {
            token: "punctuation.definition.comment",
            regex: "REM ",
            next: "comment",
            caseInsensitive: true
        },
		{
            token: "punctuation.definition.comment",
            regex: "(?<!')!.*",
            caseInsensitive: true
        },
        {
            token: "meta.tag",
            regex: "(?<=^\\d+\\s+|^\\s*)\\w+\\s*:\\s*(?=\\\\?$)",
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind+
			"\\b(?:accept|add|and|auto|begin|break|call|case|catch|class|clear|close|continue|control|create|data|def|default|"+
			"defctl|delete|dictionary|directory|disable|drop|edit|else|enable|end|end_if|end_try|error_handler|escape|event|except|"+
			"exit|exitto|file|finally|find|for|from|get|gosub|goto|hide|if|index|indexed|input|list|load|lock|merge|"+
			"next(?:\\s+record)?|object|off|on|open|perform|pop|preinput|print|process|program|properties|purge|quit|read|record|"+
			"release|remove|repeat|required|reset|restore|retry|return|run|same|save|select|server|set|set_focus|show|start|static|"+
			"step|stop|swap|switch|table|then|time|to|unique|unlock|until|wait|wend|where|while|window(?:\\+|,)?|with|write)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\*","")+
			"\\b(?:from)\\b"+
			notVarOrFuncLookAhead,
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\bpreinput","")+
			"\\b(?:next(?:\\s+record)?)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("\\bfunction\\b.+","\\)")+
			"\\b(?:for\\s+event|hide|local)\\b"+
			notVarOrFuncLookAhead,
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\(","")+
			"\\b(?:ctl|err|key|try)\\b"+
			notVarOrFuncLookAhead.replace("|//)","|//(|//)"),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.directive"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\(","")+
			"\\b(?:accept|add|addr|auto|begin|button|bye|chart|check_box|clear|clip_board|close|create|custom_vbx|cwdir|data|"+
			"day_format|def|defctl|defprt|deftty|delete|dictionary|direct|directory|disable|drop|drop_box|dump|enable|endtrace|"+
			"enter|erase|error_handler|execute|extract|file|find|floatingpoint|flush|function|get_file_box|grid|h_scrollbar|"+
			"hide|indexed|insert|invoke|iolist|keyed|let|like|line_switch|list|list_box|load|local|lock|long_form|menu_bar|merge|"+
			"message_lib|mnemonic|msgbox|multi_line|multi_media|obtain|on|open(?:\\+)?|password|perform|pop|popup_menu|precision|"+
			"prefix|preinput|print|process|program|property|purge|radio_button|randomize|read|redim|refile|release|remove|rename|"+
			"renumber|reset|restore|round|save|serial|set_focus|set_param|setctl|setday|setdrive|seterr|setesc|setfid|setmouse|"+
			"settime|settrace|short_form|show|sort|static|system_help|system_jrnl|table|translate|tristate_box|unlock|update|"+
			"user_lex|v_scrollbar|vardrop_box|varlist_box|via|video_palette|wait|winprt_setup|with|write)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.directive"
            ],
			regex: notVarOrFuncLookBehind+
			"\\b(?:dim)\\b"+
			notVarOrFuncLookAhead.replace("|//)","|//(|//)"),
            caseInsensitive: true
        },
        {
            token: "keyword.operator",
            regex: "\\b(?:And|Or)\\b",
            caseInsensitive: true
        },
        {
            token: "punctuation.definition.string.begin",
            regex: '"',
            next: "string"
        },
        {
            token: "punctuation.definition.string.hexstring",
            regex: '\\$([0-9A-Fa-f][0-9A-Fa-f])*\\$',
        },
        {
            token: "punctuation.definition.string.mnemonic",
            regex: "(?<=set_param\\s+|prm\\s*\\(\\s*)-?\\s*'..'",
        },
        {
            token: "punctuation.definition.string.mnemonic",
            regex: "(?<![a-zA-Z_][a-zA-Z0-9_]*)'_?[a-zA-Z0-9+\\-]+'(?![a-zA-Z_][a-zA-Z0-9_]*)",
        },
        {
            token: "support.function",
            regex: "(?<!(?:\\bfunction\\b.+)\\s*|'|\\.)"+
			"(?:@|@x|@y|\\b(?:Abs|Acs|And|Arg|Asc|Asn|Ath|Atn|Bin|Bsz|Chg|Chr|Cmp|Cos|Cpl|Crc|Cse|Ctl|Cvs|Dec|Deg|Dim|Dir|Dll|Dlx|"+
			"Dsk|Dte|Env|Ept|Err|Evn|Evs|Exp|Ffn|Fib|Fid|Fin|Fpt|Gap|Gbl|Gep|Hsa|Hsh|Hta|Hwn|I3E|I86|Ind|Int|Iol|Ior|Jst|Jul|Kec|"+
			"Kef|Kel|Ken|Kep|Key|Kgn|Lcs|Len|Lno|Log|Lrc|Lst|Max|Mem|Mid|Min|Mnm|Mod|Msg|Msk|Mxc|Mxl|New|Not|Nul|Num|Obj|Opt|Pad|"+
			"Pck|Pfx|Pgm|Pos|Prc|Prm|Pth|Pub|Rad|Rcd|Rdx|Rec|Ref|Rnd|Rno|Sep|Sgn|Sin|Sqr|Srt|Ssz|Stk|Stp|Str|Sub|Swp|Sys|Tan|Tbl|"+
			"Tcb|Tmr|Trx|Try|Tsk|Txh|Txw|Ucp|Ucs|Upk|Vin|Vis|Xeq|Xfa|Xml|Xor)\\b)"+
			"(?=\\s*\\(\\)?)",
            caseInsensitive: true
        },
        {
            token: [
                "constant.numeric"
            ],
            regex: "\\.?\\b(?:(?:0(?:x|X)[0-9a-fA-F]*)|(?:[0-9]+\\.?[0-9]*)(?:(?:e|E)(?:\\+|-)?[0-9]+)?)(?:L|l|UL|ul|u|U|F|f)?\\b"
        },
        {
            token: [
                "entity.name.function"
            ],
            regex: "(?:(\\b[a-zA-Z_x7f-xff][a-zA-Z0-9_x7f-xff]*?\\b\\$?)(?=\\s*\\(\\)?))"
        },
        {
            token: [
                "keyword.operator"
            ],
            regex: "\\-|\\+|\\*|\\\/|\\>|\\<|\\=|\\&"
        }
    ],
    "state_3": [
        {
            token: [
                "meta.odd-tab.tabs",
                "meta.even-tab.tabs"
            ],
            regex: "(\\t)(\\t)?"
        },
        {
            token: "meta.leading-space",
            regex: "(?=[^\\t])",
            next: "start"
        },
        {
            token: "meta.leading-space",
            regex: ".",
            next: "state_3"
        }
    ],
    "state_4": [
        {
            token: ["meta.odd-tab.spaces", "meta.even-tab.spaces"],
            regex: "(  )(  )?"
        },
        {
            token: "meta.leading-space",
            regex: "(?=[^ ])",
            next: "start"
        },
        {
            defaultToken: "meta.leading-space"
        }
    ],
    "comment": [
        {
            token: "comment.line.apostrophe",
            regex: "$|(?=(?:%>))",
            next: "start"
        },
        {
            defaultToken: "comment.line.apostrophe"
        }
    ],
    "string": [
        {
            token: "constant.character.escape.apostrophe",
            regex: '""'
        },
        {
            token: "string.quoted.double",
            regex: '"',
            next: "start"
        },
        {
            defaultToken: "string.quoted.double"
        }
    ]
}

};

oop.inherits(PxPlusHighlightRules, TextHighlightRules);

exports.PxPlusHighlightRules = PxPlusHighlightRules;
});

ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"], function(require, exports, module) {
"use strict";

var oop = require("../../lib/oop");
var Behaviour = require("../behaviour").Behaviour;
var TokenIterator = require("../../token_iterator").TokenIterator;
var lang = require("../../lib/lang");

var SAFE_INSERT_IN_TOKENS =
    ["text", "paren.rparen", "punctuation.operator"];
var SAFE_INSERT_BEFORE_TOKENS =
    ["text", "paren.rparen", "punctuation.operator", "comment"];

var context;
var contextCache = {};
var initContext = function(editor) {
    var id = -1;
    if (editor.multiSelect) {
        id = editor.selection.index;
        if (contextCache.rangeCount != editor.multiSelect.rangeCount)
            contextCache = {rangeCount: editor.multiSelect.rangeCount};
    }
    if (contextCache[id])
        return context = contextCache[id];
    context = contextCache[id] = {
        autoInsertedBrackets: 0,
        autoInsertedRow: -1,
        autoInsertedLineEnd: "",
        maybeInsertedBrackets: 0,
        maybeInsertedRow: -1,
        maybeInsertedLineStart: "",
        maybeInsertedLineEnd: ""
    };
};

var getWrapped = function(selection, selected, opening, closing) {
    var rowDiff = selection.end.row - selection.start.row;
    return {
        text: opening + selected + closing,
        selection: [
                0,
                selection.start.column + 1,
                rowDiff,
                selection.end.column + (rowDiff ? 0 : 1)
            ]
    };
};

var CstyleBehaviour = function() {
    this.add("braces", "insertion", function(state, action, editor, session, text) {
        var cursor = editor.getCursorPosition();
        var line = session.doc.getLine(cursor.row);
        if (text == '{') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && selected !== "{" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '{', '}');
            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                if (/[\]\}\)]/.test(line[cursor.column]) || editor.inMultiSelectMode) {
                    CstyleBehaviour.recordAutoInsert(editor, session, "}");
                    return {
                        text: '{}',
                        selection: [1, 1]
                    };
                } else {
                    CstyleBehaviour.recordMaybeInsert(editor, session, "{");
                    return {
                        text: '{',
                        selection: [1, 1]
                    };
                }
            }
        } else if (text == '}') {
            initContext(editor);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == '}') {
                var matching = session.$findOpeningBracket('}', {column: cursor.column + 1, row: cursor.row});
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        } else if (text == "\n" || text == "\r\n") {
            initContext(editor);
            var closing = "";
            if (CstyleBehaviour.isMaybeInsertedClosing(cursor, line)) {
                closing = lang.stringRepeat("}", context.maybeInsertedBrackets);
                CstyleBehaviour.clearMaybeInsertedClosing();
            }
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar === '}') {
                var openBracePos = session.findMatchingBracket({row: cursor.row, column: cursor.column+1}, '}');
                if (!openBracePos)
                     return null;
                var next_indent = this.$getIndent(session.getLine(openBracePos.row));
            } else if (closing) {
                var next_indent = this.$getIndent(line);
            } else {
                CstyleBehaviour.clearMaybeInsertedClosing();
                return;
            }
            var indent = next_indent + session.getTabString();

            return {
                text: '\n' + indent + '\n' + next_indent + closing,
                selection: [1, indent.length, 1, indent.length]
            };
        } else {
            CstyleBehaviour.clearMaybeInsertedClosing();
        }
    });

    this.add("braces", "deletion", function(state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '{') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.end.column, range.end.column + 1);
            if (rightChar == '}') {
                range.end.column++;
                return range;
            } else {
                context.maybeInsertedBrackets--;
            }
        }
    });

    this.add("parens", "insertion", function(state, action, editor, session, text) {
        if (text == '(') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '(', ')');
            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                CstyleBehaviour.recordAutoInsert(editor, session, ")");
                return {
                    text: '()',
                    selection: [1, 1]
                };
            }
        } else if (text == ')') {
            initContext(editor);
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == ')') {
                var matching = session.$findOpeningBracket(')', {column: cursor.column + 1, row: cursor.row});
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        }
    });

    this.add("parens", "deletion", function(state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '(') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == ')') {
                range.end.column++;
                return range;
            }
        }
    });

    this.add("brackets", "insertion", function(state, action, editor, session, text) {
        if (text == '[') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '[', ']');
            } else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                CstyleBehaviour.recordAutoInsert(editor, session, "]");
                return {
                    text: '[]',
                    selection: [1, 1]
                };
            }
        } else if (text == ']') {
            initContext(editor);
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == ']') {
                var matching = session.$findOpeningBracket(']', {column: cursor.column + 1, row: cursor.row});
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        }
    });

    this.add("brackets", "deletion", function(state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '[') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == ']') {
                range.end.column++;
                return range;
            }
        }
    });

    this.add("string_dquotes", "insertion", function(state, action, editor, session, text) {
        if (text == '"' || text == "'") {
            initContext(editor);
            var quote = text;
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && selected !== "'" && selected != '"' && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, quote, quote);
            } else if (!selected) {
                var cursor = editor.getCursorPosition();
                var line = session.doc.getLine(cursor.row);
                var leftChar = line.substring(cursor.column-1, cursor.column);
                var rightChar = line.substring(cursor.column, cursor.column + 1);
                
                var token = session.getTokenAt(cursor.row, cursor.column);
                var rightToken = session.getTokenAt(cursor.row, cursor.column + 1);
                if (leftChar == "\\" && token && /escape/.test(token.type))
                    return null;
                
                var stringBefore = token && /string|escape/.test(token.type);
                var stringAfter = !rightToken || /string|escape/.test(rightToken.type);
                
                var pair;
                if (rightChar == quote) {
                    pair = stringBefore !== stringAfter;
                } else {
                    if (stringBefore && !stringAfter)
                        return null; // wrap string with different quote
                    if (stringBefore && stringAfter)
                        return null; // do not pair quotes inside strings
                    var wordRe = session.$mode.tokenRe;
                    wordRe.lastIndex = 0;
                    var isWordBefore = wordRe.test(leftChar);
                    wordRe.lastIndex = 0;
                    var isWordAfter = wordRe.test(leftChar);
                    if (isWordBefore || isWordAfter)
                        return null; // before or after alphanumeric
                    if (rightChar && !/[\s;,.})\]\\]/.test(rightChar))
                        return null; // there is rightChar and it isn't closing
                    pair = true;
                }
                return {
                    text: pair ? quote + quote : "",
                    selection: [1,1]
                };
            }
        }
    });

    this.add("string_dquotes", "deletion", function(state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && (selected == '"' || selected == "'")) {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == selected) {
                range.end.column++;
                return range;
            }
        }
    });

};

    
CstyleBehaviour.isSaneInsertion = function(editor, session) {
    var cursor = editor.getCursorPosition();
    var iterator = new TokenIterator(session, cursor.row, cursor.column);
    if (!this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS)) {
        var iterator2 = new TokenIterator(session, cursor.row, cursor.column + 1);
        if (!this.$matchTokenType(iterator2.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS))
            return false;
    }
    iterator.stepForward();
    return iterator.getCurrentTokenRow() !== cursor.row ||
        this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_BEFORE_TOKENS);
};

CstyleBehaviour.$matchTokenType = function(token, types) {
    return types.indexOf(token.type || token) > -1;
};

CstyleBehaviour.recordAutoInsert = function(editor, session, bracket) {
    var cursor = editor.getCursorPosition();
    var line = session.doc.getLine(cursor.row);
    if (!this.isAutoInsertedClosing(cursor, line, context.autoInsertedLineEnd[0]))
        context.autoInsertedBrackets = 0;
    context.autoInsertedRow = cursor.row;
    context.autoInsertedLineEnd = bracket + line.substr(cursor.column);
    context.autoInsertedBrackets++;
};

CstyleBehaviour.recordMaybeInsert = function(editor, session, bracket) {
    var cursor = editor.getCursorPosition();
    var line = session.doc.getLine(cursor.row);
    if (!this.isMaybeInsertedClosing(cursor, line))
        context.maybeInsertedBrackets = 0;
    context.maybeInsertedRow = cursor.row;
    context.maybeInsertedLineStart = line.substr(0, cursor.column) + bracket;
    context.maybeInsertedLineEnd = line.substr(cursor.column);
    context.maybeInsertedBrackets++;
};

CstyleBehaviour.isAutoInsertedClosing = function(cursor, line, bracket) {
    return context.autoInsertedBrackets > 0 &&
        cursor.row === context.autoInsertedRow &&
        bracket === context.autoInsertedLineEnd[0] &&
        line.substr(cursor.column) === context.autoInsertedLineEnd;
};

CstyleBehaviour.isMaybeInsertedClosing = function(cursor, line) {
    return context.maybeInsertedBrackets > 0 &&
        cursor.row === context.maybeInsertedRow &&
        line.substr(cursor.column) === context.maybeInsertedLineEnd &&
        line.substr(0, cursor.column) == context.maybeInsertedLineStart;
};

CstyleBehaviour.popAutoInsertedClosing = function() {
    context.autoInsertedLineEnd = context.autoInsertedLineEnd.substr(1);
    context.autoInsertedBrackets--;
};

CstyleBehaviour.clearMaybeInsertedClosing = function() {
    if (context) {
        context.maybeInsertedBrackets = 0;
        context.maybeInsertedRow = -1;
    }
};



oop.inherits(CstyleBehaviour, Behaviour);

exports.CstyleBehaviour = CstyleBehaviour;
});

ace.define("ace/mode/pxplus",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/behaviour/cstyle","ace/mode/pxplus_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var CstyleBehaviour = require("./behaviour/cstyle").CstyleBehaviour;
var PxPlusHighlightRules = require("./pxplus_highlight_rules").PxPlusHighlightRules;

var Mode = function() {
    this.$behaviour = new CstyleBehaviour();
    this.HighlightRules = PxPlusHighlightRules;
};
oop.inherits(Mode, TextMode);

(function() {
       
    this.lineCommentStart = ["!", "REM"];
    
    this.$id = "ace/mode/pxplus";
}).call(Mode.prototype);

exports.Mode = Mode;
});
